
/*! \file 
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Secure RO Handling ATP Test source file
*
* Filename:                     ODRM_SecROHandling_RoActivation_ATP.h 
*
* 
* Created:                      17.03.2009
*
*
* \Author                      Shelly Lerman
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#ifndef _ODRM_SEC_RO_HANDLING_RO_ACTIVATION_ATP_H_
#define _ODRM_SEC_RO_HANDLING_RO_ACTIVATION_ATP_H_

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/


#ifdef __cplusplus
extern "C"
{
#endif
#include "DX_VOS_BaseTypes.h"

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_ActivationTwoConstr
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test License Pre-Processing and Activation using two constrains RO (expired and valid license). 
* Algorithm:
* 1. Get workspace size. 
* 2. Create key ring and initialize it with device private key
* 3. Initialize Secure Clock descriptor
* 4. Call to  TLK_ODRM_VerifyDeviceRoBeforeInstall() API with the device private key .
* 5. Verify that the returned key ring contains the correct keys (according to their usage flags). 
* 6. Activate content license using  TLK_ODRM_RetrieveKey() with KMAC and KREK keys from step 4 and secure clock descriptor from step 3.
* 7. Verify that TLK_ODRM_RC_ERROR_NO_VALID_RIGTHS_FOUND_IN_RO error was returned
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_ActivationTwoConstr(void);

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_ExpiredROActivation
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test License Activation using expired license
* Algorithm:
*1. Get workspace size. 
*2. Create key ring and initialize it with device private key
*3. Call to  TLK_ODRM_ProcessRegistration() API for RI Issuer registration
*4. Call to  TLK_ODRM_VerifyDeviceRoBeforeInstall() API with the device private key .
*5. Activate content license using  TLK_ODRM_RetrieveKey() with KMAC and
*   KREK keys from step 4, secure clock descriptor from step 3 and RO XML with    expired rights.
*6. Verify that TLK_ODRM_RC_ERROR_NO_VALID_RIGTHS_FOUND_IN_RO error was returned
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_ExpiredROActivation(void);


/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_ParentChiledROActivation
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test activation of license with parent license object in Secure RO Handling 
* Algorithm:
* 1. Get workspace size. 
*2. Create key ring and initialize it with device private key
*3. Call to  TLK_ODRM_ProcessRegistration() API  for RI Issuer registration
*4. Call to TLK_ODRM_VerifyDeviceRoBeforeInstall() API with the device private key and RO XML.
*5. Call to TLK_ODRM_VerifyDeviceRoBeforeInstall() API with the device private key and Parent RO XML.
*6. Activate content license using  TLK_ODRM_RetrieveKey() with keys from step 4, 5 and secure clock descriptor from step 3.
*7. Validate that  this is correct RO key.
*   7.1 Encrypt Plain text with the activated RO key from    TLK_ODRM_RetrieveKey().
*   7.2 compare it to the Encrypted plain text with the 
*       original RO key
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_ParentChiledROActivation(void);

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_GroupROActivation
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test activation of license with group ID in Secure RO Handling 
* Algorithm:
* 1. Get workspace size. 
* 2. Create key ring and initialize it with device private key
* 3. Call to  TLK_ODRM_ProcessRegistration() API  for RI Issuer registration
* 4. Call to TLK_ODRM_VerifyDeviceRoBeforeInstall() API with the device private key and RO XML with group ID.
* 5. Activate content license using  TLK_ODRM_RetrieveKey() with keys from step 4 and secure clock descriptor from step 3 and encrypted group key.
* 6. Validate that  this is correct RO key.
*    6.1  Encrypt Plain text with the activated RO key from    TLK_ODRM_RetrieveKey().
*    6.2 compare it to the Encrypted plain text with the 
*        original RO key
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_GroupROActivation(void);
/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_ROActivationWithInvGroupKey
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test activation of license with invalid group ID in Secure RO Handling 
* Algorithm:
* 1. Get workspace size. 
* 2. Create key ring and initialize it with device private key
* 3. Call to  TLK_ODRM_ProcessRegistration() API  for RI Issuer registration
* 4. Call to TLK_ODRM_VerifyDeviceRoBeforeInstall() API with the device private key and RO XML with group ID.
* 5. Activate content license using  TLK_ODRM_RetrieveKey() with keys from step 4 and secure clock descriptor from step 3 and without encrypted group key.
* 6. Verify that incorrect key was returned
* 7. Activate content license using  TLK_ODRM_RetrieveKey() with keys from step 4 and secure clock descriptor from step 3 and invalid encrypted group key.
* 8. Verify that incorrect key error was returned
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_ROActivationWithInvGroupKey(void);


#ifdef __cplusplus
}
#endif

#endif
